<?php

namespace App\Models\Finance;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Settlement extends Model 
{

    protected $table = 'settlement';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function bank_account_from()
    {
        return $this->belongsTo('App\Models\Person\BankAccount', 'bank_account_from_id');
    }

    public function bank_account_to()
    {
        return $this->belongsTo('App\Models\Person\BankAccount', 'bank_account_to_id');
    }

    public function reconciliations()
    {
        return $this->hasMany('App\Models\Finance\InvoiceReconciliation', 'settlement_id');
    }

}